DESCRIPTION OF MAXIMUM OF T TEST

Introduction
------------

This test is one that has to be seen to be believed.  What we do
is:

    1.  Generate a set of N sequences each of some length, t (say);
    2.  Take the largest of each sequence.  Call this largest number
	X(k), k = 1, N;
    3.  Sort the array X in ascending order;
    4.  Let V(k) = X(k) / (RAND_MAX + 1); then 0 <= V(k) < 1;
    5.  Apply the Kolmogorov-Smirnov test to the sequence V(k) with
	the distribution function F(x) = x^t.

That F(x) = x^t is the distribution function for the V(k) is verified
as follows (K1, p. 68):

    The probability that max(V(1), V(2),...,V(k)) <= x is
    the probability that V(1) <= x and V(2) <= x and ... and
    V(k) <= x is the product of the individual probabilities,
    namely xx...x = x^t.

The maximum of t test is implemented as maxoftst.exe.  This program
performs a Kolmogorov-Smirnov (KS) analysis on probabilities from 100
individual KS tests each conducted as described above.  Each test
produces a two KS probabilities.  These probabilities are stored in
arrays.  Each array is processed by library function KSCalc() to
produce two sets of KS statistics and probabilities.  Output consists
of printouts of these KS statistics and probabilities.
